/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.ProcessorHandler;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MonasteryStairsProcessor
extends StructureProcessor {
    public static final MonasteryStairsProcessor INSTANCE = new MonasteryStairsProcessor();
    public static final Codec<MonasteryStairsProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static final BlockState andesiteStairs = Blocks.f_50639_.m_49966_();
    private static final BlockState cobbledDeepslate = Blocks.f_152551_.m_49966_();
    private static final BlockState cobbledDeepslateWall = Blocks.f_152554_.m_49966_();
    private static final BlockState air = Blocks.f_50016_.m_49966_();
    private static final BlockState[] STAIR = new BlockState[]{Blocks.f_50016_.m_49966_(), andesiteStairs};
    private static final BlockState[] RAIL = new BlockState[]{cobbledDeepslateWall, cobbledDeepslate};

    protected StructureProcessorType<?> m_6953_() {
        return ProcessorHandler.STAIRS_PROCESSOR;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, StructureTemplate template) {
        BlockState startingState = blockInfoGlobal.f_74676_();
        if (startingState.m_60713_(Blocks.f_50634_) || startingState.m_60713_(Blocks.f_50199_)) {
            WorldGenRegion worldGenRegion;
            BlockState[] blocksToPlace;
            Direction facing = ((Direction)blockInfoGlobal.f_74676_().m_61143_((Property)StairBlock.f_56841_)).m_122424_();
            facing = structurePlacementData.m_74404_().m_55954_(facing);
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
            if (startingState.m_60713_(Blocks.f_50634_)) {
                blocksToPlace = STAIR;
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), (BlockState)andesiteStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)facing), blockInfoGlobal.f_74677_());
            } else {
                blocksToPlace = RAIL;
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), cobbledDeepslate, blockInfoGlobal.f_74677_());
            }
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos(blockInfoGlobal.f_74675_()))) {
                return blockInfoGlobal;
            }
            for (int i = 0; i < 20; ++i) {
                BlockPos.MutableBlockPos mutable = blockInfoGlobal.f_74675_().m_122032_().m_122173_(Direction.DOWN);
                BlockState currBlockState = levelReader.m_8055_((BlockPos)mutable);
                int j = 0;
                while (mutable.m_123342_() > levelReader.m_141937_() && mutable.m_123342_() < levelReader.m_151558_() && !currBlockState.m_280296_()) {
                    BlockState newState;
                    if (j < blocksToPlace.length) {
                        newState = blocksToPlace[j];
                        ++j;
                    } else {
                        newState = this.chooseRandomState(random);
                    }
                    levelReader.m_46865_((BlockPos)mutable).m_6978_((BlockPos)mutable, newState, false);
                    mutable.m_122173_(Direction.DOWN);
                    mutable.m_122173_(facing);
                    currBlockState = levelReader.m_8055_((BlockPos)mutable);
                }
            }
        }
        return blockInfoGlobal;
    }

    public BlockState chooseRandomState(RandomSource random) {
        float v = random.m_188501_();
        if ((double)v > 0.7) {
            return Blocks.f_152555_.m_49966_();
        }
        return Blocks.f_152551_.m_49966_();
    }
}

